<?php
require_once 'includes/config.php';

try {
    // Bersihkan data panggilan yang gagal
    $stmt = $db->prepare("
        UPDATE target_numbers 
        SET call_sid = NULL,
            call_date = NULL,
            created_at = CURRENT_TIMESTAMP
        WHERE status = '-'
        AND pressed_button = '-'
    ");
    
    $result = $stmt->execute();
    
    if ($result) {
        $affected = $stmt->rowCount();
        error_log("Successfully cleaned up {$affected} failed call records");
        echo json_encode(['success' => true, 'affected' => $affected]);
    } else {
        throw new Exception("Failed to clean up call data");
    }
    
} catch (Exception $e) {
    error_log("Clean up error: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
} 