<?php
require_once 'includes/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Hapus semua data dari tabel target_numbers
        $stmt = $db->prepare("DELETE FROM target_numbers");
        $stmt->execute();
        
        // Reset auto increment
        $stmt = $db->prepare("ALTER TABLE target_numbers AUTO_INCREMENT = 1");
        $stmt->execute();
        
        $response = [
            'success' => true,
            'message' => 'All data has been cleared successfully'
        ];
        
    } catch (Exception $e) {
        error_log("Clear data error: " . $e->getMessage());
        
        $response = [
            'success' => false,
            'message' => "Failed to clear data: " . $e->getMessage()
        ];
    }
    
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
} 