-- Buat database baru untuk distribusi nomor
CREATE DATABASE IF NOT EXISTS db_callv3mkt;
USE db_callv3mkt;

-- Tabel untuk nomor yang didistribusikan
CREATE TABLE distributed_numbers (
    id INT PRIMARY KEY AUTO_INCREMENT,
    marketing_id INT NOT NULL,
    phone_number VARCHAR(20) NOT NULL,
    pressed_button CHAR(1) NOT NULL,
    status VARCHAR(20) NOT NULL,
    original_call_date DATETIME NOT NULL,
    distributed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Menambahkan index untuk optimasi query
CREATE INDEX idx_marketing_phone ON distributed_numbers(marketing_id, phone_number);
CREATE INDEX idx_status ON distributed_numbers(status); 