<?php
require_once 'includes/config.php';

try {
    $db_auth->exec("USE " . DB_AUTH_NAME);
    
    // Password yang sama untuk semua user
    $password = 'admin123';
    $hash = password_hash($password, PASSWORD_DEFAULT);
    
    // Update password di semua tabel
    $tables = ['superadmin', 'supervisor', 'developer'];
    
    foreach ($tables as $table) {
        $stmt = $db_auth->prepare("UPDATE $table SET password = ? WHERE username = ?");
        $stmt->execute([$hash, $table]);
        echo "Password reset for $table user<br>";
        
        // Verifikasi password baru
        $stmt = $db_auth->prepare("SELECT password FROM $table WHERE username = ?");
        $stmt->execute([$table]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result && password_verify($password, $result['password'])) {
            echo "Password verification successful for $table<br>";
        } else {
            echo "Password verification failed for $table<br>";
        }
        echo "<hr>";
    }
    
} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?> 