<?php 
require_once 'includes/config.php';
include 'includes/header.php';
include 'includes/sidebar.php';

// Handle audio uploads
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $uploadStatus = [];
    
    try {
        // Create uploads directory if not exists
        if (!file_exists(AUDIO_UPLOAD_PATH)) {
            mkdir(AUDIO_UPLOAD_PATH, 0777, true);
        }

        $audioType = '';
        $file = null;

        // Determine which audio is being uploaded
        if (isset($_FILES['welcome_audio'])) {
            $audioType = 'welcome';
            $file = $_FILES['welcome_audio'];
        } elseif (isset($_FILES['confirmation_audio'])) {
            $audioType = 'confirmation';
            $file = $_FILES['confirmation_audio'];
        } elseif (isset($_FILES['error_audio'])) {
            $audioType = 'error';
            $file = $_FILES['error_audio'];
        }

        if ($file && $audioType) {
            // Validate file
            if ($file['error'] !== UPLOAD_ERR_OK) {
                throw new Exception('File upload failed with error code: ' . $file['error']);
            }

            if ($file['type'] !== 'audio/mpeg' && $file['type'] !== 'audio/mp3') {
                throw new Exception('Invalid file type. Only MP3 files are allowed.');
            }

            // Generate unique filename
            $filename = $audioType . '_' . time() . '.mp3';
            $filepath = AUDIO_UPLOAD_PATH . $filename;

            // Move uploaded file
            if (!move_uploaded_file($file['tmp_name'], $filepath)) {
                throw new Exception('Failed to move uploaded file.');
            }

            // Update database
            $stmt = $db->prepare("INSERT INTO audio_settings (type, file_name, file_path) 
                                VALUES (?, ?, ?) 
                                ON DUPLICATE KEY UPDATE 
                                file_name = VALUES(file_name), 
                                file_path = VALUES(file_path)");
            $stmt->execute([$audioType, $filename, $filename]);

            $uploadStatus = [
                'success' => true,
                'message' => "Audio $audioType has been uploaded successfully."
            ];
        }
    } catch (Exception $e) {
        $uploadStatus = [
            'success' => false,
            'message' => $e->getMessage()
        ];
    }
    
    // Store status in session and redirect
    $_SESSION['upload_status'] = $uploadStatus;
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Get status from session if exists
if (isset($_SESSION['upload_status'])) {
    if ($_SESSION['upload_status']['success']) {
        $success = $_SESSION['upload_status']['message'];
    } else {
        $error = $_SESSION['upload_status']['message'];
    }
    unset($_SESSION['upload_status']);
}

// Get current audio files
$stmt = $db->query("SELECT type, file_name FROM audio_settings");
$currentFiles = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
?>

<title>Settings - Miracle-TECH Phone Call System</title>

<div class="content" id="content">
    <div class="container-fluid">
        <h1 class="h3 mb-4">Settings</h1>

        <?php if (isset($success)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo htmlspecialchars($success); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>

        <?php if (isset($error)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo htmlspecialchars($error); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>
        
        <div class="row">
            <!-- Audio Welcome Card -->
            <div class="col-md-4">
                <div class="card">
                    <div class="card-body p-4">
                        <h5 class="card-title mb-3">
                            <i class="fas fa-music text-primary me-2"></i>Audio Welcome
                        </h5>
                        <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" enctype="multipart/form-data">
                            <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">
                            <div class="mb-3">
                                <div class="input-group">
                                    <span class="input-group-text bg-light">
                                        <i class="fas fa-file-audio text-primary"></i>
                                    </span>
                                    <input type="file" class="form-control" name="welcome_audio" accept=".mp3" required>
                                </div>
                                <small class="text-muted">Current file: <?php echo htmlspecialchars($currentFiles['welcome'] ?? 'No file uploaded'); ?></small>
                            </div>
                            <div class="d-grid">
                                <button type="submit" name="upload_welcome" class="btn btn-primary">
                                    <i class="fas fa-upload me-2"></i>Upload
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Audio Confirmation Card -->
            <div class="col-md-4">
                <div class="card">
                    <div class="card-body p-4">
                        <h5 class="card-title mb-3">
                            <i class="fas fa-music text-success me-2"></i>Audio Confirmation
                        </h5>
                        <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" enctype="multipart/form-data">
                            <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">
                            <div class="mb-3">
                                <div class="input-group">
                                    <span class="input-group-text bg-light">
                                        <i class="fas fa-file-audio text-success"></i>
                                    </span>
                                    <input type="file" class="form-control" name="confirmation_audio" accept=".mp3" required>
                                </div>
                                <small class="text-muted">Current file: <?php echo htmlspecialchars($currentFiles['confirmation'] ?? 'No file uploaded'); ?></small>
                            </div>
                            <div class="d-grid">
                                <button type="submit" name="upload_confirmation" class="btn btn-success">
                                    <i class="fas fa-upload me-2"></i>Upload
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Audio Error Card -->
            <div class="col-md-4">
                <div class="card">
                    <div class="card-body p-4">
                        <h5 class="card-title mb-3">
                            <i class="fas fa-music text-danger me-2"></i>Audio Error
                        </h5>
                        <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" enctype="multipart/form-data">
                            <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">
                            <div class="mb-3">
                                <div class="input-group">
                                    <span class="input-group-text bg-light">
                                        <i class="fas fa-file-audio text-danger"></i>
                                    </span>
                                    <input type="file" class="form-control" name="error_audio" accept=".mp3" required>
                                </div>
                                <small class="text-muted">Current file: <?php echo htmlspecialchars($currentFiles['error'] ?? 'No file uploaded'); ?></small>
                            </div>
                            <div class="d-grid">
                                <button type="submit" name="upload_error" class="btn btn-danger">
                                    <i class="fas fa-upload me-2"></i>Upload
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?> 