<?php include 'includes/header.php'; ?>
<?php include 'includes/sidebar.php'; ?>

<?php 
// Cek apakah user adalah supervisor, developer, atau superadmin
if ($_SESSION['role'] !== 'supervisor' && $_SESSION['role'] !== 'developer' && $_SESSION['role'] !== 'superadmin') {
    header("Location: dashboard.php");
    exit();
}

// Handle form submission untuk edit admin
if (isset($_POST['update'])) {
    // Verifikasi CSRF token
    if (!verifyCSRFToken($_POST['csrf_token'])) {
        $_SESSION['error'] = "Invalid security token!";
        header("Location: users.php");
        exit();
    }

    $username = sanitize_input($_POST['username']);
    $password = $_POST['password'];
    $password_confirmation = $_POST['password_confirmation'];
    
    try {
        $db_auth->exec("USE " . DB_AUTH_NAME);
        
        // Validasi
        if ($password !== '') {
            if (strlen($password) < 6) {
                throw new Exception("Password must be at least 6 characters long");
            }
            if ($password !== $password_confirmation) {
                throw new Exception("Password confirmation does not match");
            }
            
            // Update username dan password
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $db_auth->prepare("
                UPDATE supervisor 
                SET username = ?, password = ? 
                WHERE id = ?
            ");
            $stmt->execute([$username, $hash, $_SESSION['user_id']]);
            
        } else {
            // Update username saja
            $stmt = $db_auth->prepare("
                UPDATE supervisor 
                SET username = ? 
                WHERE id = ?
            ");
            $stmt->execute([$username, $_SESSION['user_id']]);
        }
        
        $_SESSION['success'] = "Profile updated successfully!";
        header("Location: users.php");
        exit();
        
    } catch (Exception $e) {
        $_SESSION['error'] = $e->getMessage();
        header("Location: users.php");
        exit();
    }
}

// Ambil data supervisor untuk ditampilkan di form
try {
    $db_auth->exec("USE " . DB_AUTH_NAME);
    $stmt = $db_auth->prepare("SELECT username FROM supervisor WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    error_log("Error fetching supervisor data: " . $e->getMessage());
    $admin = ['username' => ''];
}
?>

<div class="content" id="content">
    <div class="container-fluid">
        <h1 class="h3 mb-4">Users</h1>
        
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger">
                <?php 
                echo $_SESSION['error'];
                unset($_SESSION['error']);
                ?>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success">
                <?php 
                echo $_SESSION['success'];
                unset($_SESSION['success']);
                ?>
            </div>
        <?php endif; ?>
        
        <!-- Admin Edit Card -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Admin Edit</h5>
            </div>
            <div class="card-body p-4">
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">
                    
                    <div class="mb-4">
                        <div class="input-group">
                            <span class="input-group-text bg-light">
                                <i class="fas fa-user text-primary"></i>
                            </span>
                            <input type="text" class="form-control" id="username" name="username" 
                                value="<?php echo htmlspecialchars($admin['username']); ?>" required>
                        </div>
                    </div>
                    
                    <div class="mb-4">
                        <div class="input-group">
                            <span class="input-group-text bg-light">
                                <i class="fas fa-key text-primary"></i>
                            </span>
                            <input type="password" class="form-control" id="password" name="password" 
                                placeholder="Enter new password">
                        </div>
                        <small class="text-muted">Leave blank if you don't want to change the password</small>
                    </div>

                    <div class="mb-4">
                        <div class="input-group">
                            <span class="input-group-text bg-light">
                                <i class="fas fa-lock text-primary"></i>
                            </span>
                            <input type="password" class="form-control" id="password_confirmation" 
                                name="password_confirmation" placeholder="Confirm new password">
                        </div>
                    </div>

                    <div class="d-grid">
                        <button type="submit" name="update" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>UPDATE
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?> 